% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_gaps.R
\name{fill_down_until}
\alias{fill_down_until}
\title{Fill down tibble columns until a maximum number of time slots}
\usage{
fill_down_until(dtf, varnames, max_timeslots = 1)
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}

\item{varnames}{character or vector of characters,
column names with NA values}

\item{max_timeslots}{integer, maximum number of time slots to fill}
}
\value{
tibble
}
\description{
Fill down tibble columns until a maximum number of time slots
}
\examples{
down_data <- data.frame(
  datetime = as.POSIXct("2024-01-01 00:00:00", tz = "UTC") + 0:5 * 3600,
  temperature = c(15, 15, NA, NA, NA, 16)
)
fill_down_until(down_data, "temperature", max_timeslots = 2)

}
