% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{reassignAlleles}
\alias{reassignAlleles}
\title{Correct allele calls based on a personalized genotype}
\usage{
reassignAlleles(
  data,
  genotype_db,
  v_call = "v_call",
  seq = "sequence_alignment",
  method = "hamming",
  path = NA,
  keep_gene = c("gene", "family", "repertoire")
)
}
\arguments{
\item{data}{\code{data.frame} containing V allele calls from a
single subject and the sample IMGT-gapped V(D)J sequences under
\code{seq}.}

\item{genotype_db}{vector of named nucleotide germline sequences
matching the calls detailed in \code{allele_calls}
and personalized to the subject}

\item{v_call}{name of the column in \code{data} with V allele
calls. Default is \code{v_call}.}

\item{seq}{name of the column in \code{data} with the
aligned, IMGT-numbered, V(D)J nucleotide sequence.
Default is SEQUENCE_IMGT}

\item{method}{method to use when realigning sequences to
the genotype_db sequences. Currently, only \code{"hammming"}
(for Hamming distance) is implemented.}

\item{path}{directory containing the tool used in the
realignment method, if needed. Hamming distance does
not require a path to a tool.}

\item{keep_gene}{string indicating if the gene (\code{"gene"}),
family (\code{"family"}) or complete repertoire
(\code{"repertoire"}) assignments should be performed.
Use of \code{"gene"} increases speed by minimizing required number of
alignments, as gene level assignments will be maintained when possible.}
}
\value{
A modified input \code{data.frame} containing the best allele call from
          among the sequences listed in \code{genotype_db} in the
          \code{v_call_genotyped} column.
}
\description{
\code{reassignAlleles} uses a subject-specific genotype to correct
correct preliminary allele assignments of a set of sequences derived
from a single subject.
}
\details{
In order to save time, initial gene assignments are preserved and
the allele calls are chosen from among those provided in \code{genotype_db},
based on a simple alignment to the sample sequence.
}
\examples{
# Extract the database sequences that correspond to the genotype
genotype_db <- genotypeFasta(SampleGenotype, SampleGermlineIGHV, novel=SampleNovel)

# Use the personalized genotype to determine corrected allele assignments
output_db <- reassignAlleles(AIRRDb, genotype_db, v_call="v_call",
                             seq="sequence_alignment")

}
