% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_cached_item.R
\name{tw_get_cache_table_name}
\alias{tw_get_cache_table_name}
\title{Gets name of table inside the database}
\usage{
tw_get_cache_table_name(
  type = "item",
  language = tidywikidatar::tw_get_language(),
  response_language = tidywikidatar::tw_get_language()
)
}
\arguments{
\item{type}{Defaults to "item". Type of cache file to output. Values
typically used by \code{tidywikidatar} include "item", "search_item",
"search_property", and "qualifier".}

\item{language}{Language to be used for the search. Can be set once per
session with \code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full
list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{response_language}{Language to be used for the returned labels and
descriptions. Corresponds to the \code{uselang} parameter of the MediaWiki API,
as described
\href{https://www.wikidata.org/w/api.php?action=help&modules=wbsearchentities}{in
the official documentation}. Can be set once per session with
\code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{all
available language codes}.}
}
\value{
A character vector of length one with the name of the relevant table
in the cache file.
}
\description{
Gets name of table inside the database
}
\examples{
# outputs name of table used in the cache database
tw_get_cache_table_name(type = "item", language = "en")
}
