% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univar.R
\name{univar}
\alias{univar}
\title{Descriptive statistics}
\usage{
univar(
  df,
  colvar = NULL,
  tablebyvar = NULL,
  rowvar = NULL,
  rowbyvar = NULL,
  statlist = getOption("tidytlg.univar.statlist.default"),
  decimal = 1,
  precisionby = NULL,
  precisionon = NULL,
  wide = FALSE,
  alpha = 0.05,
  rowtext = NULL,
  row_header = NULL,
  .keep = TRUE,
  .ord = FALSE,
  ...
)
}
\arguments{
\item{df}{(required) dataframe containing records to summarize by treatment.}

\item{colvar}{(required) character vector of the treatment variable within
the dataframe.}

\item{tablebyvar}{(optional) repeat entire table by variable within \code{df}.}

\item{rowvar}{(required) character vector of variable to summarize within the
dataframe.}

\item{rowbyvar}{(optional) repeat \code{rowvar} by variable within \code{df}.}

\item{statlist}{(optional) \code{statlist} object of stats to keep (default =
\code{statlist(c("N", "MEANSD", "MEDIAN", "RANGE", "IQRANGE"))}).}

\item{decimal}{(optional) decimal precision root level, when using
\code{presisionby} this will be used as the base decimal cap (default = 1).}

\item{precisionby}{(optional) vector of by variable(s) to use when
calculating parameter based precision.}

\item{precisionon}{(optional) variable to use when calculating parameter
based precision. If \code{precisionby} is specified but not \code{precisionon}
this will default to \code{rowvar}.}

\item{wide}{(optional) logical indicating to convert labels to column and
columns to labels (default = \code{FALSE}).}

\item{alpha}{(optional) alpha level for 2-sided confidence interval (default
= 0.05).}

\item{rowtext}{(optional) A text string to replace the \code{label} value on the
table. Useful for tables with a single row.}

\item{row_header}{(optional) A row to add as a header for the table.}

\item{.keep}{(optional) Should the \code{rowbyvar} and \code{tablebyvar} be
output in the table. If \code{FALSE}, \code{rowbyvar} will still be output
in the \code{label} column. (default = \code{TRUE}).}

\item{.ord}{Should the ordering columns be output with the table? This is
useful if a table needs to be merged or reordered in any way after build.}

\item{...}{(optional) Named arguments to be included as columns on the table.}
}
\value{
dataframe of results
}
\description{
Univariate statistics for a variables by treatment and/or group.
}
\examples{
adsl <-
  structure(
    list(
      USUBJID = c(
        "DEMO-101", "DEMO-102", "DEMO-103", "DEMO-104",
        "DEMO-105", "DEMO-106"
      ),
      AGE = c(59, 51, 57, 65, 21, 80),
      SEX = c("F", "M", "F", "M", "F", "M"),
      WEIGHTBL = c(83.6, 75, 84, 90, 65, 70),
      colnbr = structure(
        c(1L, 3L, 2L, 2L, 3L, 1L),
        .Label = c("Placebo", "Low", "High"),
        class = "factor"
      )
    ),
    row.names = c(NA, 6L),
    class = "data.frame"
  )

# N, Mean(SD), Median, Range, IQ Range for a rowvar by colvar
univar(adsl,
  colvar = "colnbr",
  rowvar = "AGE"
)

# N and Mean for a rowvar by colvar
univar(adsl,
  colvar   = "colnbr",
  rowvar   = "AGE",
  statlist = statlist(c("N", "MEAN"))
)

# N and Mean for a rowvar by colvar and a by variable
univar(adsl,
  colvar   = "colnbr",
  rowvar   = "AGE",
  rowbyvar = "SEX",
  statlist = statlist(c("N", "MEAN"))
)

# Below illustrates how make the same calls to univar() as above, using table
# and column metadata # along with generate_results().

column_metadata <- tibble::tribble(
  ~tbltype, ~coldef, ~decode,
  "type1", "0", "Placebo",
  "type1", "54", "Low",
  "type1", "81", "High"
)

# N, Mean(SD), Median, Range, IQ Range for a rowvar by colvar
table_metadata <- tibble::tribble(
  ~anbr, ~func, ~df, ~rowvar, ~tbltype, ~colvar,
  "1", "univar", "cdisc_adae", "AGE", "type1", "TRTA"
)

generate_results(table_metadata,
  column_metadata = column_metadata,
  tbltype = "type1"
)


# N and Mean for a rowvar by colvar
table_metadata <- tibble::tribble(
  ~anbr, ~func, ~df, ~rowvar, ~tbltype, ~colvar, ~statlist,
  "1", "univar", "cdisc_adae", "AGE", "type1", "TRTA",
  statlist(c("N", "MEAN"))
)

generate_results(table_metadata,
  column_metadata = column_metadata,
  tbltype = "type1"
)


# N and Mean for a rowvar by colvar and a by variable
table_metadata <- tibble::tribble(
  ~anbr, ~func, ~df, ~rowvar, ~tbltype, ~colvar, ~statlist, ~by,
  "1", "univar", "cdisc_adae", "AGE", "type1", "TRTA",
  statlist(c("N", "MEAN")), "SEX"
)

generate_results(table_metadata,
  column_metadata = column_metadata,
  tbltype = "type1"
)
}
