# Extracted from test-extrema.R:291

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "tidyna", path = "..")
attach(test_env, warn.conflicts = FALSE)

# prequel ----------------------------------------------------------------------
x_na <- c(1, NA, 3)
x_clean <- c(1, 2, 3)
x_nan <- c(1, NaN, 5)
x_na_and_nan <- c(1, NA, NaN, 5)
x_inf <- c(1, Inf, 3)
x_neginf <- c(-Inf, 2, 3)
x_both_inf <- c(-Inf, 0, Inf)

# test -------------------------------------------------------------------------
warnings <- testthat::capture_warnings(
    result <- pmin(c(NA, 1), c(NA, 2))
  )
expect_equal(result, c(NA, 1))
expect_length(warnings, 2)
