% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyboot.R
\name{tidyboot.data.frame}
\alias{tidyboot.data.frame}
\title{Non-parametric bootstrap for data frames}
\usage{
\method{tidyboot}{data.frame}(
  data,
  column = NULL,
  summary_function = mean,
  statistics_functions,
  nboot = 1000,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{column}{A column of \code{data} to bootstrap over (if not supplied,
summary_function and statistic_function must operate over the appropriate
data frame).}

\item{summary_function}{A function to be computed over each set of samples as
a data frame, or a function to be computed over each set of samples as a
single column of a data frame indicated by \code{column} (defaults to
\code{mean}).}

\item{statistics_functions}{A function to be computed over each set of
samples as a data frame, or a named list of functions to be computed over
each set of samples as a single column of a data frame indicated by
\code{column}.}

\item{nboot}{The number of bootstrap samples to take (defaults to
\code{1000}).}

\item{...}{Other arguments passed from generic.}
}
\description{
Computes arbitrary bootstrap statistics on univariate data.
}
\examples{
## Mean and 95\% confidence interval for 500 samples from two different normal distributions
require(dplyr)
gauss1 <- tibble(value = rnorm(500, mean = 0, sd = 1), condition = 1)
gauss2 <- tibble(value = rnorm(500, mean = 2, sd = 3), condition = 2)
df <- bind_rows(gauss1, gauss2)

mean_ci_funs <- list("ci_lower" = ci_lower, "mean" = mean, "ci_upper" = ci_upper)
df \%>\% group_by(condition) \%>\%
  tidyboot(column = value, summary_function = mean, statistics_functions = mean_ci_funs)

df \%>\% group_by(condition) \%>\%
  tidyboot(summary_function = function(x) x \%>\% summarise(stat = mean(value)),
           statistics_functions = function(x) x \%>\%
             summarise(across(stat, mean_ci_funs, .names = "{.fn}")))
}
