% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{get_center_of_mass}
\alias{get_center_of_mass}
\title{Get center of mass from tree bole segments QSM (X, Y, Z)}
\usage{
get_center_of_mass(qsm)
}
\arguments{
\item{qsm}{qsm object loaded from `[load_qsm]`.}
}
\value{
A tibble with one row and three numeric columns:
\describe{
  \item{X}{Volume-weighted X coordinate of the trunk center of mass (m).}
  \item{Y}{Volume-weighted Y coordinate of the trunk center of mass (m).}
  \item{Z}{Volume-weighted Z coordinate of the trunk center of mass (m).}
}
}
\description{
This function calculates the center of mass/volume from a QSM
by estimating the centroid of cylinder locations, each weighted
by their volume. Only trunk sections are included (e.g., `branching_order == 0`).
For center of mass, assumes constant density
within segments.
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
print(get_center_of_mass(qsm))
}
