% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{sd_copy_value}
\alias{sd_copy_value}
\title{Create a copy of a value}
\usage{
sd_copy_value(id, id_copy)
}
\arguments{
\item{id}{Character string. The ID of the input value to copy.}

\item{id_copy}{Character string. The ID for the new copy (must be different
from \code{id}).}
}
\value{
\code{NULL} invisibly. This function is called for its side effects.
}
\description{
This function creates a copy of an input value and makes it available as a
new output. The new output can then be displayed using \code{sd_output()}.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Use sd_copy_value() to copy an input value to display elsewhere:
  # server <- function(input, output, session) {
  #   sd_copy_value(id = "name", id_copy = "name_copy")
  #   ...
  # }
  # Then in survey.qmd, display it in an R chunk:
  # sd_output("name", type = "value")

  # Find a working directory and start from a template:
  sd_create_survey(template = "default")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
\seealso{
\code{sd_output()} for displaying the copied value
}
