% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survHE-package.R
\docType{package}
\name{survHE-package}
\alias{survHE}
\alias{survHE-package}
\title{survHE: Survival Analysis in Health Economic Evaluation}
\description{
Contains a suite of functions for survival analysis in health economics. These can be used to run survival models under a frequentist (based on maximum likelihood) or a Bayesian approach (both based on Integrated Nested Laplace Approximation or Hamiltonian Monte Carlo). To run the Bayesian models, the user needs to install additional modules (packages), i.e. 'survHEinla' and 'survHEhmc'. These can be installed from \url{https://giabaio.r-universe.dev/} using 'install.packages("survHEhmc", repos = c("https://giabaio.r-universe.dev", "https://cloud.r-project.org"))' and 'install.packages("survHEinla", repos = c("https://giabaio.r-universe.dev", "https://cloud.r-project.org"))' respectively. 'survHEinla' is based on the package INLA, which is available for download at \url{https://inla.r-inla-download.org/R/stable/}. The user can specify a set of parametric models using a common notation and select the preferred mode of inference. The results can also be post-processed to produce probabilistic sensitivity analysis and can be used to export the output to an Excel file (e.g. for a Markov model, as often done by modellers and practitioners). \doi{10.18637/jss.v095.i14}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/giabaio/survHE}
  \item \url{https://gianluca.statistica.it/software/survhe/}
  \item Report bugs at \url{https://github.com/giabaio/survHE/issues}
}

}
\author{
\strong{Maintainer}: Gianluca Baio \email{g.baio@ucl.ac.uk}

Other contributors:
\itemize{
  \item Andrea Berardi \email{and.be.like@gmail.com} [contributor]
  \item Philip Cooney \email{philip.cooney@hotmail.com} [contributor]
  \item Andrew Jones \email{andrew.r.johnson@postgrad.curtin.edu.au} [contributor]
  \item Nathan Green \email{n.green@ucl.ac.uk} [contributor]
}

}
\keyword{internal}
