% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homing.R
\name{homing}
\alias{homing}
\title{Homing: Relink De-identified Data Using Lookup Table}
\usage{
homing(
  deidentified_data,
  lookup_table,
  hash_col_name = "row_hash",
  keep_hash = TRUE
)
}
\arguments{
\item{deidentified_data}{A de-identified data frame containing a hash column
(typically the output from molting()$deidentified).}

\item{lookup_table}{The lookup table data frame that maps anonymous hash values
back to original identifiers. Created by molting(), it contains the hash column
plus all removed identifier columns (names, dates of birth, medical record
numbers, etc.). This serves as the secure "key" for relinking de-identified
data back to real identities. Each row maps one hash to one set of identifiers.
Typically obtained as molting()$lookup. Example structure for a dataset that
had patient_name, dob, and mrn removed: row_hash | patient_name | dob | mrn.}

\item{hash_col_name}{The name of the hash column used for linking. Must exist
in both deidentified_data and lookup_table. Defaults to "row_hash".}

\item{keep_hash}{Logical. If TRUE (default), keeps the hash column in the
relinked data. If FALSE, removes it after relinking.}
}
\value{
A data frame with the original identifiers merged back in.
}
\description{
Like homing pigeons finding their way back, this function relinks
de-identified data with original identifiers using the lookup table
created by molting().
}
\examples{
\dontrun{
# First, de-identify the data
result <- molting(patient_data)

# Later, relink when needed
original_data <- homing(
  result$deidentified,
  result$lookup
)
}

}
