% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{sqlf_parse}
\alias{sqlf_parse}
\title{Parse a SQL query}
\usage{
sqlf_parse(sql = NULL, file = NULL, dialect = NULL, config = NULL, glue = NULL)
}
\arguments{
\item{sql}{A SQL string to parse.}

\item{file}{Path to a SQL file to parse.}

\item{dialect}{SQL dialect (e.g. `"ansi"`, `"bigquery"`, `"postgres"`).}

\item{config}{A [sqlf_config()] object.}

\item{glue}{If `TRUE`, treat `\{var\}` placeholders as `glue::glue_sql`
variables before parsing. `NULL` (the default) reads the `glue` setting
from the project `.sqlfluff` config file; `FALSE` explicitly disables
glue handling regardless of project config.}
}
\value{
A nested list representing the parse tree.
}
\description{
Parses a SQL string or file into a syntax tree using sqlfluff.
}
\examples{
\dontshow{if (reticulate::virtualenv_exists("r-sqlfluffr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sqlf_parse(sql = "SELECT 1\n")
\dontshow{\}) # examplesIf}
}
