% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{auc}
\alias{auc}
\title{Area under the ROC curve}
\usage{
auc(o, p)
}
\arguments{
\item{o}{Numeric vector of actual binary labels (0 or 1). Must have the same length as \code{p}.}

\item{p}{Numeric vector of predicted probabilities (typically 0 to 1). Must have the same length as \code{o}.}
}
\value{
Numeric value between 0 and 1 representing the AUC. Higher values indicate better classification performance, with 0.5 indicating random performance and 1.0 indicating perfect classification.
}
\description{
Computes the area under the ROC curve (AUC) for binary classification.
}
\examples{

auc(
  o = c(0, 0, 1, 1),
  p = c(0.1, 0.6, 0.4, 0.8)
  )

}
\seealso{
Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{beowulf_cluster}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
