% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trophic.R
\name{trophic}
\alias{trophic}
\title{Create a trophic table}
\usage{
trophic(data = NULL, from = NULL, to = NULL, weight = NULL)
}
\arguments{
\item{data}{(Optional) A data.frame containing link information.}

\item{from}{(Optional) Character string. Name of the column in \code{data} containing source nodes.}

\item{to}{(Optional) Character string. Name of the column in \code{data} containing target nodes.}

\item{weight}{(Optional) Character string. Name of the column in \code{data} containing weights.
Default is 1 if not specified.}
}
\value{
An object of class \code{trophic_tbl}.
}
\description{
Creates a data.frame of class \code{trophic_tbl} designed to store trophic links.
Can be initialized empty or from an existing data.frame.
}
\examples{
# 1. Empty initialization (pipe style)
net <- trophic() |>
  add_link("sol", "sp1")

# 2. Initialization from data.frame
df_raw <- data.frame(src = c("A", "A"), target = c("B", "C"), w = c(2, 5))
net_from_df <- trophic(df_raw, from = "src", to = "target", weight = "w")

}
