% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacemodel.R
\name{spacemodel}
\alias{spacemodel}
\title{Create a spacemodel object}
\usage{
spacemodel(raster_stack, trophic_tbl)
}
\arguments{
\item{raster_stack}{A \code{\link[terra]{SpatRaster}} object (multi-layer stack) representing
the spatial distribution of the species or groups.}

\item{trophic_tbl}{An object of class \code{trophic_tbl} containing the
ecological parameters and properties of the species.}
}
\value{
A \code{\link[terra]{SpatRaster}} object with the following additional attributes:
\itemize{
  \item \code{trophic_tbl}: The \code{trophic_tbl} object passed as input.
  \item \code{spacemodel}: A logical flag set to \code{TRUE}, indicating this raster
  is part of a spacemodel.
}
}
\description{
Constructor for the `spacemodel` class. This function combines spatial data
(a raster stack) and ecological data (a trophic table) into a single object
used for modelling.
}
\details{
The function performs several checks to ensure data consistency:
\itemize{
  \item Verifies that \code{raster_stack} is a \code{SpatRaster}.
  \item Verifies that \code{trophic_tbl} is a \code{trophic_tbl} object.
  \item Ensures the number of raster layers matches the number of levels in the trophic table.
  \item Ensures that the names of the raster layers match the names in the trophic table.
}
}
\seealso{
\code{\link[terra]{rast}}, \code{trophic_tbl}
}
