% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/habitat.R
\name{habitat}
\alias{habitat}
\title{Create a Habitat object}
\usage{
habitat(geometry = NULL, habitat = NULL, weight = NULL)
}
\arguments{
\item{geometry}{An object of class \code{sf} or \code{sfc}. Optional, default is empty.}

\item{habitat}{Logical vector indicating habitat presence. Default is logical(0).}

\item{weight}{Numeric vector of weights. Default is numeric(0).}
}
\value{
An object of class \code{habitat}, inheriting from \code{sf} and \code{data.frame}.
}
\description{
Create a spatial Habitat object based on an optional \code{sf} data.frame.
If no geometry is provided, creates an empty Habitat object.
The object has columns:
\itemize{
  \item \code{habitat}: logical, TRUE/FALSE
  \item \code{weight}: numeric
  \item \code{geometry}: sfc geometry
}
}
\examples{
library(sf)

# Empty habitat
h <- habitat()
h

# Habitat with geometries
geom <- st_sfc(
  st_point(c(0, 0)),
  st_point(c(1, 1)),
  crs = 4326
)

hab <- habitat(
  geometry = geom,
  habitat = c(TRUE, FALSE),
  weight = c(0.8, 0)
)
hab
}
