% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{print.ipw_ci}
\alias{print.ipw_ci}
\title{Print method for "ipw_ci" objects}
\usage{
\method{print}{ipw_ci}(x, ...)
}
\arguments{
\item{x}{Object of class "ipw_ci".}

\item{...}{Other arguments.}
}
\value{
No value is returned.
}
\description{
Print method for objects of class "ipw_ci".
}
\examples{
\donttest{
set.seed(1234)
data_null_processed <- prep_data(data = data_null, grace_period_length = 2,
                                 baseline_vars = 'L')
res_est <- ipw(data = data_null_processed,
               time_smoothed = TRUE,
               outcome_times = c(6, 12, 18, 24),
               A_model = A ~ L + Z,
               R_model_numerator = R ~ L_baseline + Z,
               R_model_denominator = R ~ L + A + Z,
               Y_model = Y ~ L_baseline * (time + Z))
res_ci <- get_CI(ipw_res = res_est, data = data_null_processed, n_boot = 10)
print(res_ci)
}

}
\seealso{
\code{\link{get_CI}}
}
