# Generated by roxytest: do not edit by hand!

# File R/fitsmm.R: @testexamples

test_that("Function fitsmm() @ L213", {
  
  states <- c("a", "c", "g", "t")
  s <- length(states)
  
  # Creation of the initial distribution
  vect.init <- c(1 / 4, 1 / 4, 1 / 4, 1 / 4)
  
  # Creation of the transition matrix
  pij <- matrix(c(0, 0.2, 0.5, 0.3, 
                  0.2, 0, 0.3, 0.5, 
                  0.3, 0.5, 0, 0.2, 
                  0.4, 0.2, 0.4, 0), 
                ncol = s, byrow = TRUE)
  
  # Creation of the distribution matrix
  
  distr.matrix <- matrix(c(NA, "pois", "geom", "nbinom", 
                           "geom", NA, "pois", "dweibull",
                           "pois", "pois", NA, "geom", 
                           "pois", "geom", "geom", NA), 
                         nrow = s, ncol = s, byrow = TRUE)
  
  # Creation of an array containing the parameters
  param1.matrix <- matrix(c(NA, 2, 0.4, 4, 
                            0.7, NA, 5, 0.6, 
                            2, 3, NA, 0.6, 
                            4, 0.3, 0.4, NA), 
                          nrow = s, ncol = s, byrow = TRUE)
  
  param2.matrix <- matrix(c(NA, NA, NA, 0.6, 
                            NA, NA, NA, 0.8, 
                            NA, NA, NA, NA, 
                            NA, NA, NA, NA), 
                          nrow = s, ncol = s, byrow = TRUE)
  
  param.array <- array(c(param1.matrix, param2.matrix), c(s, s, 2))
  
  # Specify the semi-Markov model
  semimarkov <- smmparametric(states = states, init = vect.init, ptrans = pij, 
                              type.sojourn = "fij", distr = distr.matrix, 
                              param = param.array)
  
  seqs <- simulate(object = semimarkov, nsim = c(1000, 10000, 2000), seed = 100)
  
  # Estimation of simulated sequences
  est <- fitsmm(sequences = seqs, states = states, type.sojourn = "fij", 
                distr = distr.matrix)
  
  expect_equal(length(seqs), 3)
  expect_true(all(sapply(seqs, length) >= c(1000, 10000, 2000)))
  expect_equal(seqs[[1]][995:1000], c("t","t","t","t","c","t"))
})

