% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{potatorow}
\alias{potatorow}
\title{Potato yields with row data}
\format{
A data frame with 6 variables: \code{ID}, \code{Block}, \code{Plot}, \code{Row}, \code{Fungicide}, \code{RowYield}.
\describe{
  \item{ID}{Factor. Unique identifier for each row yield observation.}
  \item{Block}{Factor. Block number in the randomized complete block design with four levels.}
  \item{Plot}{Factor. Plot number within each block (1–5).}
  \item{Row}{Factor. Row number within each plot, corresponding to individual row yields.}
  \item{Fungicide}{Factor. Fungicide treatment applied to the plot ("Control", "F1", "F2", "F3", or "F4").}
  \item{RowYield}{Integer. Potato yield measured for the individual row (units as recorded, e.g., grams or kilograms).}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
potatorow
}
\description{
This dataset presents individual row yields from a field experiment designed as a randomized complete block design to evaluate the effects of four different fungicides (F1, F2, F3, and F4) compared with untreated control plots on potato yield. The trial was arranged as four blocks, each containing five plots, for a total of 20 units. For this analysis, yield measurements are broken down to the level of individual rows within each plot. The dataset includes classifying factors for Block, Plot, and Row, enabling detailed investigation of within-plot and within-block variation, as well as the overall impact of fungicide treatments on potato yield.
}
\examples{
summary(aov(RowYield ~ Fungicide + Error(Block/Plot/Row), data = potatorow))

}
\keyword{datasets}
