% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{six_bucket_delete}
\alias{six_bucket_delete}
\title{Delete an S3 bucket}
\usage{
six_bucket_delete(bucket, force = FALSE, ...)
}
\arguments{
\item{bucket}{(character) bucket name. required}

\item{force}{(logical) force deletion without going through the prompt.
default: \code{FALSE}. Should only be set to \code{TRUE} when required for
non-interactive use.}

\item{...}{named parameters passed on to
\href{https://www.paws-r-sdk.com/docs/s3_delete_bucket/}{delete_bucket}}
}
\value{
\code{NULL}, invisibly
}
\description{
Takes care of deleting bucket objects, so that the bucket itself
can be deleted cleanly
}
\section{What is magical}{

\itemize{
\item Exits early if bucket does not exist
\item Checks for any objects in the bucket and deletes any present
\item Deletes bucket after deleting objects
}
}

\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# bucket does not exist
six_bucket_delete("notabucket")

# bucket exists w/o objects
bucket <- random_bucket()
aws_bucket_create(bucket)
six_bucket_delete(bucket, force = TRUE)

# bucket exists w/ objects (files and directories with files)
bucket <- random_bucket()
aws_bucket_create(bucket)
demo_rds_file <- file.path(system.file(), "Meta/demo.rds")
links_file <- file.path(system.file(), "Meta/links.rds")
aws_file_upload(
  c(demo_rds_file, links_file),
  s3_path(bucket, c(basename(demo_rds_file), basename(links_file)))
)
aws_file_upload(
  c(demo_rds_file, links_file),
  s3_path(
    bucket, "newfolder",
    c(basename(demo_rds_file), basename(links_file))
  )
)
aws_bucket_list_objects(bucket)
six_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_bucket_upload}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_upload}()}

Other magicians: 
\code{\link{six_admin_setup}()},
\code{\link{six_bucket_upload}()},
\code{\link{six_file_upload}()},
\code{\link{six_user_create}()},
\code{\link{six_user_delete}()}
}
\concept{buckets}
\concept{magicians}
