% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roles.R
\name{aws_role_create}
\alias{aws_role_create}
\title{Create a role}
\usage{
aws_role_create(
  name,
  assume_role_policy_document,
  path = NULL,
  description = NULL,
  max_session_duration = NULL,
  permission_boundary = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{(character) A role name. required}

\item{assume_role_policy_document}{(character) The trust relationship policy
document that grants an entity permission to assume the role. json as string.
required}

\item{path}{(character) The path for the role name. optional.
If it is not included, it defaults to a slash (/).}

\item{description}{(character) a description fo the role. optional}

\item{max_session_duration}{(character) The maximum session duration
(in seconds) that you want to set for the specified role. optional}

\item{permission_boundary}{(character) The ARN of the managed policy
that is used to set the permissions boundary for the role. optional}

\item{tags}{(list) A list of tags that you want to attach to the new user.
optional}
}
\value{
A tibble with information about the role created
}
\description{
Create a role
}
\details{
See \url{https://www.paws-r-sdk.com/docs/iam_create_role/}
docs for details on the parameters
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
role_name <- "AMinorRole"
trust_policy <- list(
  Version = "2012-10-17",
  Statement = list(
    list(
      Effect = "Allow",
      Principal = list(
        Service = "lambda.amazonaws.com"
      ),
      Action = "sts:AssumeRole"
    )
  )
)
doc <- jsonlite::toJSON(trust_policy, auto_unbox = TRUE)
desc <- "My test role"
z <- aws_role_create(role_name,
  assume_role_policy_document = doc,
  description = desc
)
# attach a policy
invisible(z \%>\% aws_policy_attach("AWSLambdaBasicExecutionRole"))

# cleanup
invisible(z \%>\% aws_policy_detach("AWSLambdaBasicExecutionRole"))
aws_role_delete(role_name)
\dontshow{\}) # examplesIf}
}
\seealso{
Other roles: 
\code{\link{aws_role}()},
\code{\link{aws_role_delete}()},
\code{\link{aws_role_exists}()},
\code{\link{aws_roles}()}
}
\concept{roles}
