% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy_delete_version}
\alias{aws_policy_delete_version}
\title{Delete a policy version}
\usage{
aws_policy_delete_version(name, version_id)
}
\arguments{
\item{name}{(character) a policy name. required. within the function
we lookup the policy arn which is what's passed to the AWS API}

\item{version_id}{(character) The policy version to delete. required.
Allows (via regex) a string of characters that consists of the lowercase
letter 'v' followed by one or two digits, and optionally followed by a
period '.' and a string of letters and digits.}
}
\value{
invisibly returns \code{NULL}
}
\description{
Delete a policy version
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (aws_policy_exists("RdsAllow888")) {
  aws_policy_delete("RdsAllow888")
}

# Create policy document
doc <- aws_policy_document_create(
  aws_policy_statement(
    action = "rds-db:connect",
    resource = "*"
  )
)

# Create policy
invisible(aws_policy_create("RdsAllow888", document = doc))

# Add a new version of the policy
st8ment1 <- aws_policy_statement("iam:GetUser", "*")
new_doc <- aws_policy_document_create(st8ment1)
arn <- as_policy_arn("RdsAllow888", local = TRUE)
aws_policy_update(arn, document = new_doc, defaul = TRUE)

# List versions of the policy
aws_policy_list_versions("RdsAllow888")

# Delete a policy version
aws_policy_delete_version("RdsAllow888", "v1")

# Cleanup - delete  policy
aws_policy_delete("RdsAllow888")
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.paws-r-sdk.com/docs/iam_delete_policy_version/}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policies}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
