% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy_delete}
\alias{aws_policy_delete}
\title{Delete a user managed policy}
\usage{
aws_policy_delete(name)
}
\arguments{
\item{name}{(character) a policy name. required. within the function
we lookup the policy arn which is what's passed to the AWS API}
}
\value{
invisibly returns \code{NULL}
}
\description{
Delete a user managed policy
}
\section{AWS managed policies}{

You can not delete AWS managed policies.
}

\section{Deleting process (adapted from \code{paws} docs)}{

Before you can delete a managed policy, you must first detach
the policy from all users, groups, and roles that it is attached to.
In addition, you must delete all the policy's versions. The following
steps describe the process for deleting a managed policy:
\itemize{
\item Detach the policy from all users, groups, and roles that the policy is
attached to using \code{\link[=aws_policy_attach]{aws_policy_attach()}}. To list all the users, groups,
and roles that a policy is attached to use \code{\link[=aws_policy_list_entities]{aws_policy_list_entities()}}
\item Delete all versions of the policy using \code{\link[=aws_policy_delete_version]{aws_policy_delete_version()}}.
To list the policy's versions, use \code{\link[=aws_policy_list_versions]{aws_policy_list_versions()}}. You cannot
use \code{\link[=aws_policy_delete_version]{aws_policy_delete_version()}} to delete the version that is marked as
the default version. You delete the policy's default version in the next
step of the process.
\item Delete the policy using this function (this automatically deletes the
policy's default version)
}
}

\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (aws_policy_exists("RdsAllow456")) {
  aws_policy_delete("RdsAllow456")
}

# Create policy document
doc <- aws_policy_document_create(
  aws_policy_statement(
    action = "rds-db:connect",
    resource = "*"
  )
)

# Create policy
invisible(aws_policy_create("RdsAllow456", document = doc))

# Delete policy
aws_policy_delete("RdsAllow456")
\dontshow{\}) # examplesIf}
}
\references{
\href{https://www.paws-r-sdk.com/docs/iam_delete_policy/}{delete_policy}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policies}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
