% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverseScHazTV.R
\name{inverseScHazTV}
\alias{inverseScHazTV}
\title{Wrapper for inverse cumulative hazard}
\usage{
inverseScHazTV(
  p,
  t,
  lower = 1e-15,
  upper = 200,
  t_prime,
  eta,
  nu,
  phi,
  phi_prime,
  at_risk,
  tol = 1e-09,
  max_iter = 100
)
}
\arguments{
\item{p}{The random variable (typically \code{-log(U)}).}

\item{t}{The time of the previous event}

\item{lower}{Lower bound for root finding.}

\item{upper}{Upper bound for root finding.}

\item{t_prime}{The time where the time varying effects change}

\item{eta}{Numeric vector of shape parameters.}

\item{nu}{Numeric vector of scale parameters.}

\item{phi}{Numeric vector of multiplicative effect bedfore time t_prime}

\item{phi_prime}{Numeric vector of multiplicative effects after time t_prime}

\item{at_risk}{Numeric vector indicating at-risk indicators for each event type.}

\item{tol}{Numeric tolerance for root-finding. Default is 1e-9.}

\item{max_iter}{Maximum iterations. Default is 100.}
}
\value{
A numeric scalar, the root \code{u}.
}
\description{
A wrapper around the Rcpp function \code{inverseScHazCppTV}, used to find the inverse
of the summed cumulative hazard.
}
\examples{
eta <- c(0.1, 0.1)
nu <- c(1.1, 1.1)
phi <- c(1, 1)
at_risk <- c(1, 1)
phi_prime <- c(2, 2)
inverseScHazTV(p = 0.5, t= 1, t_prime = 2, eta = eta, nu = nu,
                       phi = phi, phi_prime = phi_prime, at_risk = at_risk)

}
