% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_filter_logical.R
\name{get_filter_logical}
\alias{get_filter_logical}
\title{Compute a Filter Predicate}
\usage{
get_filter_logical(x, val, ...)
}
\arguments{
\item{x}{An object to filter; typically a data.frame.}

\item{val}{The filter criteria.}

\item{...}{Arguments passed to methods. See details.}
}
\value{
A logical vector indicating which elements of \code{x} match the filter
criteria specified by \code{val}.
}
\description{
Computes a logical vector indicating which elements of \code{x} match the filter
criteria specified by \code{val}.
}
\details{
The following arguments are supported in \code{...}:

\describe{
\item{column}{When \code{x} is a data.frame, \code{column} is the name of the
column intended to be filtered.}
\item{comparison}{When \code{x} is a numeric or Date and \code{val} is a
length-\strong{one} numeric or Date, \code{comparison} is the function used to
compare \code{x} with \code{val}. The default is \code{<=}.}
\item{gte}{When \code{x} is a numeric or Date and \code{val} is a length-\strong{two}
numeric or Date, \code{gte} controls whether to use \code{>=} (\code{TRUE}, default)
or \code{>} (\code{FALSE}) on \code{val[[1]]}.}
\item{lte}{When \code{x} is a numeric or Date and \code{val} is a length-\strong{two}
numeric or Date, \code{lte} controls whether to use \code{<=} (\code{TRUE}, default)
or \code{<} (\code{FALSE}) on \code{val[[2]]}.}
}
}
\examples{
df <- data.frame(
  category = rep(letters[1:3], each = 4),
  value = 1:12,
  date = Sys.Date() + 0:11
)

# Filter character column
get_filter_logical(df, c("a", "b"), column = "category")

# Filter numeric column with single value
get_filter_logical(df, 5, column = "value", comparison = `<=`)

# Filter numeric column with range
get_filter_logical(df, c(3, 8), column = "value", gte = TRUE, lte = FALSE)

}
