% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_tools.R
\name{combine_yaml_recursive}
\alias{combine_yaml_recursive}
\title{Combine YAML files recursively from subdirectories}
\usage{
combine_yaml_recursive(
  base_dir,
  current_dir = "",
  config_file = "files_desc.yaml",
  recorded_name = TRUE,
  date_time_format = "\%Y\%m\%d_\%H\%M\%S",
  add_img = FALSE,
  img_size = 30,
  format_size = TRUE
)
}
\arguments{
\item{base_dir}{Base directory path}

\item{current_dir}{Current directory relative to base_dir (use "" for base_dir itself)}

\item{config_file}{YAML configuration file name}

\item{recorded_name}{Add recorded name (with date_time extension) in output?}

\item{date_time_format}{DateTime format}

\item{add_img}{Use in shiny module for adding file extension img}

\item{img_size}{Use in shiny module for adding file extension img}

\item{format_size}{User-friendly size format?}
}
\value{
A data frame combining all YAML files with a 'subdir' column indicating relative path
}
\description{
Combine YAML files recursively from subdirectories
}
\examples{
\dontrun{
# Get all files from base_dir and subdirectories
all_files <- combine_yaml_recursive(
  base_dir = "~/my_files",
  current_dir = "",
  config_file = "files_desc.yaml"
)

# Get files from a specific subdirectory and its children
subdir_files <- combine_yaml_recursive(
  base_dir = "~/my_files",
  current_dir = "projects/2024",
  config_file = "files_desc.yaml"
)
}
}
