% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.sglg.R
\name{cweight_scheme}
\alias{cweight_scheme}
\title{case-weight scheme}
\usage{
cweight_scheme(model, ...)
}
\arguments{
\item{model}{an object of the class sglg. This object is returned from the call to glg(), sglg(), survglg() or ssurvglg().}

\item{...}{other arguments.}
}
\description{
cweight_scheme extracts from a object of class sglg the local influence measures and displays their graphs versus the index of the observations.
}
\examples{
rows <- 100
columns <- 2
t_beta  <- c(0.5, 2)
t_sigma <- 1
t_lambda <- 1
set.seed(8142031)
x1 <- rbinom(rows, 1, 0.5)
x2 <- runif(columns, 0, 1)
X <- cbind(x1,x2)
error <- rglg(rows, 0, 1, t_lambda)
y1 <- X \%*\%t_beta + t_sigma * error
data.example <- data.frame(y1,X)
fit1 <- glg(y1 ~ x1 + x2 - 1,data=data.example)
cweight_scheme(fit1)
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.

Cardozo C.A.,  Paula G., and Vanegas L. (2022). Generalized log-gamma additive partial linear models with P-spline smoothing. Statistical Papers.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
