% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_array.R
\name{df_to_array}
\alias{df_to_array}
\title{Convert a data.frame (or tibble) into a multidimensional array}
\usage{
df_to_array(df, dim_var_names, value_var_name = "value")
}
\arguments{
\item{df}{a \code{\link[=data.frame]{data.frame()}} (or \code{\link[tibble:tibble]{tibble::tibble()}}) in long format
(each row contains one value for the intended array)}

\item{dim_var_names}{a \code{\link[=character]{character()}} vector of variable names in \code{df}.
All of these variables should be factors, or a warning will be produced.}

\item{value_var_name}{a \code{\link[=character]{character()}} variable containing a variable name
from \code{df} which contains the values for the intended array.}
}
\value{
an \code{\link[=array]{array()}} with dimensions defined by the variables in \code{df}
listed in \code{dim_var_names}
}
\description{
Convert a data.frame (or tibble) into a multidimensional array
}
\examples{
library(dplyr)
library(tidyr)

df <- iris \%>\%
  tidyr::pivot_longer(
    names_to = "parameter",
    cols = c("Sepal.Length", "Sepal.Width", "Petal.Width", "Petal.Length")
  ) \%>\%
  mutate(parameter = factor(parameter, levels = unique(parameter)))
arr <- df \%>\%
  serocalculator:::df_to_array(
     dim_var_names = c("parameter", "Species"))
ftable(arr[,,1:5])
}
\keyword{internal}
