% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revenue_standardization.R
\name{standardize_revenue_units}
\alias{standardize_revenue_units}
\title{Standardize Revenue Units Across sensortowerR}
\usage{
standardize_revenue_units(data, source = "unknown", target_unit = "base")
}
\arguments{
\item{data}{Data frame containing revenue columns}

\item{source}{Character string indicating the data source}

\item{target_unit}{Character string: "base" (dollars/euros/etc) or "cents"}
}
\value{
Data frame with standardized revenue values
}
\description{
Ensures revenue values have consistent units across all sensortowerR functions.
The Sensor Tower API returns revenue in cents, but for consistency with other
functions like st_sales_report, this converts to base currency units.
}
\details{
The Sensor Tower API inconsistently returns revenue values:
- Top Charts API: revenue in cents
- Sales Report API: revenue in base currency units
- Publishers API: revenue in cents (but converts to base units)

This function ensures consistency by converting all revenue to base units
by default, while preserving the original values for reference.
}
\keyword{internal}
