% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_filter_helpers.R
\name{st_test_filter}
\alias{st_test_filter}
\title{Test a Custom Filter ID}
\usage{
st_test_filter(filter_id, os = "ios", verbose = TRUE, auth_token = NULL)
}
\arguments{
\item{filter_id}{Character string. The filter ID to test}

\item{os}{Character string. Operating system to test with. One of "ios", 
"android", or "unified". Defaults to "ios".}

\item{verbose}{Logical. Whether to print detailed test results. Defaults to TRUE.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.
Defaults to environment variable SENSORTOWER_AUTH_TOKEN.}
}
\value{
List with test results including success status and any error messages
}
\description{
Tests whether a custom filter ID works with the Sensor Tower API by making
a minimal test request. This helps verify that the filter exists and is
accessible with your authentication.
}
\examples{
\dontrun{
# Test a filter ID
result <- st_test_filter("687df26ac5a19ebcfe817d7f")

# Test silently
result <- st_test_filter("687df26ac5a19ebcfe817d7f", verbose = FALSE)

# Test with different OS
result <- st_test_filter("687df26ac5a19ebcfe817d7f", os = "unified")
}
}
