% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_utils.R
\name{st_get_filter_collection}
\alias{st_get_filter_collection}
\title{Get Pre-Built Filter Collections}
\usage{
st_get_filter_collection(
  collection = c("top_genres", "monetization_models", "platform_exclusive",
    "market_segments"),
  auth_token = NULL
)
}
\arguments{
\item{collection}{Character. Name of the collection:
- "top_genres": Major game genres
- "monetization_models": Different monetization approaches
- "platform_exclusive": Platform-specific apps
- "market_segments": Market segment filters}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
A named list of filter IDs
}
\description{
Returns commonly used filter IDs for quick access to pre-defined app segments.
}
\examples{
\dontrun{
# Get filter IDs for top game genres
genre_filters <- st_get_filter_collection("top_genres")

# Use a filter from the collection
puzzle_apps <- st_get_filtered_apps(
  filter_id = genre_filters$puzzle,
  measure = "DAU",
  regions = "US"
)
}

}
