% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_utils.R
\name{st_filter_by_date}
\alias{st_filter_by_date}
\title{Create Date-Based Filter}
\usage{
st_filter_by_date(
  released_after = NULL,
  released_before = NULL,
  region = "US",
  auth_token = NULL
)
}
\arguments{
\item{released_after}{Date or character. Apps released after this date}

\item{released_before}{Date or character. Apps released before this date}

\item{region}{Character. Region for release date ("US", "WW", "JP", "CN")}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
Character string containing the filter ID
}
\description{
Creates a filter for apps based on release date criteria.
}
\examples{
\dontrun{
# Get apps released in 2024
filter_id <- st_filter_by_date(
  released_after = "2024-01-01",
  released_before = "2024-12-31",
  region = "US"
)
}

}
