
# Expected output ---------------------------------------------------------

iris_exp <- tibble::tibble(
  term = c("Sepal.Length_n", "Sepal.Width_n", "Petal.Length_n", "Petal.Width_n", "Species_n", ".total"),
  mean = c(
    8.713333333333332930692, 12.8, 11.85333333333333349913,
    15.16666666666666607455, 50, 19.70666666666666699825
  ),
  sd = c(
    3.818599248901833220771, 7.067270245634605707608, 6.620475323744077655874,
    9.136119531260822768104, 0, 16.49782389124145964843
  ),
  median = c(9, 11, 10, 12, 50, 12),
  min = c(1, 4, 3, 1, 50, 1),
  max = c(17, 27, 27, 29, 50, 50),
  na_count = numeric(6),
  na_rate = numeric(6),
)

mtcars_exp <- tibble::tibble(
  term = c("mpg_n", "cyl_n", "disp_n", "hp_n", "drat_n", "wt_n", "qsec_n", "vs_n", "am_n", "gear_n", "carb_n", ".total"),
  mean = c(
    1.5, 19.65625, 1.375, 1.8125, 2.40625, 1.34375, 1.1875, 35.6875, 35.78125,
    22.0625, 23.375, 13.28977272727272662678
  ),
  sd = c(
    0.508000508000762, 10.18097331996973053947, 0.6599120175960897505263,
    0.8590129369261277902936, 3.130076521789533661178, 0.700662129242646258831,
    0.396557769456266029362, 1.512048386322555781902, 1.496972751707538185073,
    9.889510572057583104311, 11.1724026352956542496, 14.72719089015795645992
  ),
  median = c(1.5, 15, 1, 2, 2, 1, 1, 37, 37, 19, 33, 3),
  min = c(1, 8, 1, 1, 1, 1, 1, 34, 34, 5, 8, 1),
  max = c(2, 33, 3, 3, 19, 3, 2, 37, 37, 33, 34, 37),
  na_count = numeric(12),
  na_rate = numeric(12),
)

pigs4_exp <- tibble::tibble(
  term = c("snout_n", "tail_n", "wings_n", ".total"),
  mean = c(2, 1.6, 1.4, 1.666666666666666740682),
  sd = c(
    0.7071067811865475727373, 0.8944271909999158554072, 0.8944271909999158554072,
    0.816496580927726
  ),
  median = c(2, 1, 1, 1),
  min = rep(1, 4L),
  max = rep(3, 4L),
  na_count = numeric(4),
  na_rate = numeric(4),
)


# Testing -----------------------------------------------------------------

test_that("`audit()` for `duplicate_tally()` works correctly", {
  pigs4  %>% duplicate_tally() %>% audit() %>% expect_equal(pigs4_exp)
  iris   %>% duplicate_tally() %>% audit() %>% expect_equal(iris_exp)
  mtcars %>% duplicate_tally() %>% audit() %>% expect_equal(mtcars_exp)
})
