% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{check_fire_data}
\alias{check_fire_data}
\title{Check Consistency of Historical vs. Simulated Fire Data}
\usage{
check_fire_data(fires_hist_size, sim_perimeters_size, n_years)
}
\arguments{
\item{fires_hist_size}{Numeric vector of historical fire sizes.}

\item{sim_perimeters_size}{Numeric vector of simulated fire sizes.}

\item{n_years}{Integer. Number of years represented in the simulation.}
}
\value{
If the simulated fires are sufficient, returns an integer representing
the recommended surface threshold (in number of seasons).
If the simulations are not sufficient, prints diagnostic messages
and returns nothing.
}
\description{
This function compares historical fire sizes with simulated fire sizes
to assess whether the simulations are sufficient in terms of
maximum burned area and total burned area.
If the simulated fires are not adequate, the function prints guidance
messages suggesting additional simulations or adjustments.
}
\details{
The function checks:
\itemize{
  \item Maximum fire size in historical vs. simulated data.
  \item Total burned area in historical vs. simulated data.
}

If both criteria are satisfied, it calculates a recommended threshold
using \code{\link{get_select_params}}.
}
\examples{
# Example with toy data
set.seed(123)
hist_sizes <- rgamma(100, shape = 2, scale = 5)
sim_sizes  <- rgamma(200, shape = 2, scale = 4)

check_fire_data(fires_hist_size = hist_sizes,
                sim_perimeters_size = sim_sizes,
                n_years = 10)

}
\seealso{
\code{\link{get_select_params}}
}
