% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Write_Data.R
\name{Read10X_h5_Multi_Directory}
\alias{Read10X_h5_Multi_Directory}
\title{Load 10X h5 count matrices from multiple directories}
\usage{
Read10X_h5_Multi_Directory(
  base_path,
  secondary_path = NULL,
  default_10X_path = TRUE,
  cellranger_multi = FALSE,
  h5_filename = "filtered_feature_bc_matrix.h5",
  sample_list = NULL,
  sample_names = NULL,
  replace_suffix = FALSE,
  new_suffix_list = NULL,
  parallel = FALSE,
  num_cores = NULL,
  merge = FALSE,
  ...
)
}
\arguments{
\item{base_path}{path to the parent directory which contains all of the subdirectories of interest.}

\item{secondary_path}{path from the parent directory to count matrix files for each sample.}

\item{default_10X_path}{logical (default TRUE) sets the secondary path variable to the default 10X
directory structure.}

\item{cellranger_multi}{logical, whether samples were processed with Cell Ranger \code{multi}, default is FALSE.}

\item{h5_filename}{name of h5 file (including .h5 suffix).  If all h5 files have same name (i.e. Cell Ranger output)
then use full file name.  By default function uses Cell Ranger name: "filtered_feature_bc_matrix.h5".
If h5 files have sample specific prefixes (i.e. from Cell Bender) then use only the shared part of file
name (e.g., "_filtered_out.h5").}

\item{sample_list}{a vector of sample directory names if only specific samples are desired.  If \code{NULL} will
read in subdirectories in parent directory.}

\item{sample_names}{a set of sample names to use for each sample entry in returned list.  If \code{NULL} will
set names to the subdirectory name of each sample.}

\item{replace_suffix}{logical (default FALSE).  Whether or not to replace the barcode suffixes of matrices
using \code{\link{Replace_Suffix}}.}

\item{new_suffix_list}{a vector of new suffixes to replace existing suffixes if \code{replace_suffix = TRUE}.
See \code{\link{Replace_Suffix}} for more information.  To remove all suffixes set \code{new_suffix_list = ""}.}

\item{parallel}{logical (default FALSE) whether or not to use multi core processing to read in matrices.}

\item{num_cores}{how many cores to use for parallel processing.}

\item{merge}{logical (default FALSE) whether or not to merge samples into a single matrix or return
list of matrices.  If TRUE each sample entry in list will have cell barcode prefix added.  The prefix
will be taken from \code{sample_names}.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{Read10X_h5}}.}
}
\value{
a list of sparse matrices (merge = FALSE) or a single sparse matrix (merge = TRUE).
}
\description{
Enables easy loading of sparse data matrices provided by 10X genomics that are present in multiple
subdirectories.  Can function with either default output directory structure of Cell Ranger or
custom directory structure.
}
\examples{
\dontrun{
base_path <- 'path/to/data/directory'
expression_matrices <- Read10X_h5_Multi_Directory(base_path = base_path)
}

}
\concept{read_&_write}
