% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_plot.R
\name{plot.habitat}
\alias{plot.habitat}
\title{Plot Options For a 'habitat' Object}
\usage{
\method{plot}{habitat}(
  x,
  IC = "AICc",
  type = 1,
  powFit = TRUE,
  totSp = FALSE,
  xlab = NULL,
  ylab = NULL,
  lcol = NULL,
  pLeg = TRUE,
  legPos = "right",
  legInset = 0,
  ModTitle = NULL,
  which = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class 'habitat'.}

\item{IC}{The information criterion weights to present (must
be one of 'AIC', 'BIC' or 'AICc'), if plotting a
\code{\link{sar_habitat}} object.}

\item{type}{Whether a Type 1, 2, 3 or 4 plot should be
generated, if plotting a \code{\link{sar_countryside}}
object (see details).}

\item{powFit}{For Type 1 plots, should the predicted total
richness values of the power (or logarithmic) model be
included as red points (logical argument).}

\item{totSp}{For Type 2 and 3 plots, should a total species
curve be added which is the sum of the individual species
group curves for a given plot (default = FALSE).}

\item{xlab}{Title for x-axis (default titles are used if not provided).}

\item{ylab}{Title for y-axis (default titles are used if not provided).}

\item{lcol}{For Type 2 & 3 plots: the colours of the fitted
lines, for each component model. Should be a vector, the
length (and order) of which should match the number of
species groups in \code{x}, including the total species
group (last in the order) if \code{totSp == TRUE}. If not
included, randomly selected colours are used.}

\item{pLeg}{For Type 2 & 3 plots: should a legend be included
(logical argument), showing the line colours and
corresponding species groups.}

\item{legPos}{For Type 2 & 3 plots: the location of the legend.
Can either be a position (e.g., "bottomright"), or the x and
y co-ordinates to be used to position the legend (e.g.,
c(0,5)).}

\item{legInset}{For Type 2 & 3 plots: the inset argument in
  \code{\link[graphics]{legend}}. Enables the legend to be
  plotted outside the plotting window (it still needs the user
to manually change their graphical margin parameters).}

\item{ModTitle}{For Type 2 & 3 plots: a vector of plot titles,
which should have the same length as the number of habitats
used in the original model fit. If NULL (default), the
habitat names used in the original model fit are used. For
Type 4 plots: a vector of plot titles, which should have the
same length as the number of species groups used in the
original model fit. If NULL (default), the species group
names used in the original model fit are used. If no plot
titles are wanted, use \code{ModTitle = "none"}.}

\item{which}{For Type 2 - 4 plots: select an individual plot
to generate, rather than generating the plots for all
habitats. If not NULL (the default) should be a numeric
vector of length 1; the order of plots matches the order of
habitats / species groups in the original data used to fit
the model.}

\item{\dots}{Further graphical parameters may be supplied as
arguments.}
}
\description{
S3 method for class 'habitat'.
  \code{plot.habitat} creates plots for objects of class
  habitat, using the R base plotting framework. The exact plot
  generated depends on whether the input data come from
  \code{\link{sar_habitat}} or \code{\link{sar_countryside}}.
}
\details{
The exact plot that is generated depends on the input data. If 
 \code{x} is the fit object from \code{\link{sar_habitat}},
 a simple barplot of information criterion (IC) weights for the
 different model fits is produced. The particular IC metric to 
 use is chosen using the \code{IC} argument.
 
 If \code{x} is the fit object from
 \code{\link{sar_countryside}}, four plot types can be produced
 (selected using the \code{type} argument). A Type 1 plot
 plots the predicted total richness values (from both
 countryside and Arrhenius power (or logarithmic) SAR models)
 against the observed total richness values, with a regression
 line (intercept = 0, slope = 1) included to aid
 interpretation.
 
 A Type 2 plot uses \code{\link{countryside_extrap}}
 internally to generate separate fitted SAR curves for each of
 the modelled species groups, for each habitat individually,
 using a set of hypothetical sites (ranging in area from zero
 to the maximum observed site area value) in which the
 proportion of a given habitat is always 100 percent. See
 Matthews et al. (2025) for further details. A plot for each
 habitat is generated, unless the \code{which} argument is
 used to select the plot for a specific habitat. See the
 Examples section below.
 
 A Type 3 plot follows a similar approach as for Type 2 plots,
 but instead varies the proportion of a given habitat while
 fixing site area. The area of the largest site in \code{data}
 is used, and for a given (focal) habitat, the proportion of
 the site represented by the focal habitat is varied from zero
 up to one. As site area is fixed, as the proportion of the
 focal habitat increases, the proportions of the other
 habitats decrease at an equal rate. This process is then
 repeated using the next habitat as the focal habitat, and so
 on.
 
Note that the logarithmic SAR model doesn't work with zero
area values, so the minimum area value of the 'hypothetical'
sites used to generate the fitted curves in a Type 2 or 3 plot
is set to 0.01 if this model is used.

A Type 4 plot represents the effective area plots used in
Merckx et al. (2019). The “effective area” for species group i
in a site comprising j habitats is given by Ai= Sum over j of
hij*Aj (summed across the j habitats in the site), where hij
is the affinity of species group i to habitat j and is taken
from the fitted \code{sar_countryside} model. The effective
area of each site in the dataset is then calculated for
species group i, and the SAR plotted using the effective area
values instead of standard area. If the power form of the
countryside model was fitted, the effective area plot is
generated in log-log space and a standard log-log power model
is also generated for comparison. If the logarithmic form was
used, linear-log plots (i.e, just log-transformation of area)
are used instead. In both cases, a linear model is fitted to
the relationships and the R2 value presented on the plots.
Similarly to Type 2 and 3 plots, these plots are generated
separately for each species group; the user can choose to
generate the plot for a specific species group using the
\code{which} argument.
}
\examples{
#Run the sar_habitat function and generate a barplot of the AICc
#values
data(habitat)

s <- sar_habitat(data = habitat, modType = "power_log",
con = NULL, logT = log)

plot(s, IC = "AICc", col = "darkred")

\dontrun{
#Run the sar_countryside function and generate a Type 1 plot,
#including the predicted values of the standard power model
data(countryside)

s3 <- sar_countryside(data = countryside, modType = "power",
gridStart = "partial", habNam = c("AG", "SH",
"F"), spNam = c("AG_Sp", "SH_Sp", "F_Sp", "UB_Sp"))

plot(s3, type = 1, powFit = TRUE)

#Generate Type 2 plots providing set line colours, plot titles,
#and modifying other aspects of the plot using the standard
#base R plotting commands.

 plot(s3, type = 2, lcol = c("black", "aquamarine4",
"#CC661AB3" , "darkblue"), pLeg = TRUE, lwd = 1.5, 
 ModTitle = c("Agricultural land", "Shrubland", "Forest"))
 
#Generate the same plots, but all in a single plotting window,
#using the ask argument
 par(mfrow = c(2, 2))
 plot(s3, type = 2, lcol = c("black", "aquamarine4",
"#CC661AB3" , "darkblue"), pLeg = FALSE, lwd = 1.5, 
 ModTitle = c("Agricultural land", "Shrubland", "Forest"),
 ask = FALSE)
 
 dev.off()
 
#Select a single plot to generate, including
#a legend and positioning it outside the main plotting window.
#Note this will change the graphical margins of your plotting
#window.
par(mar=c(5.1, 4.1, 4.1, 7.5), xpd=TRUE)

plot(s3, type = 2, lcol = c("black", "aquamarine4",
"#CC661AB3" , "darkblue"), pLeg = TRUE,  legPos ="topright",
legInset = c(-0.2,0.3), lwd = 1.5, ModTitle = "Forest",
which = 3)

dev.off()

#Generate Type 3 plots (here only displaying the first), including
#a total species richness curve
plot(s3, totSp = TRUE, type = 3, lcol = c("black",
"aquamarine4", "#CC661AB3" , "darkblue", "darkgrey"), pLeg =
TRUE, lwd = 1.5, ModTitle = c("Agricultural land",
"Shrubland", "Forest"), which =1)

#Generate Type 4 plots (here only displaying the first)
plot(s3, type = 4, which =1)

}
}
\references{
Matthews et al. (2025) An R package for fitting
  multi-habitat species–area relationship models. In prep.
  
  Merckx, T., Dantas de Miranda, M. & Pereira, H.M. (2019)
  Habitat amount, not patch size and isolation, drives species
  richness of macro-moth communities in countryside
  landscapes. Journal of Biogeography, 46, 956–967.
}
