% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_issue_template.R
\name{use_issue_template}
\alias{use_issue_template}
\title{Use Issue Template}
\usage{
use_issue_template(
  templates = c("bug_report.yml", "feature_request.yml", "config.yml"),
  save_dir = here::here(".github", "ISSUE_TEMPLATE"),
  path = file.path(save_dir, templates),
  force_new = FALSE,
  show = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{templates}{The names of templates to be used.}

\item{save_dir}{Directory to save the Docker file to.}

\item{path}{Path to the Docker file.}

\item{force_new}{If a Docker file already exists, overwrite it 
(default: \code{FALSE}).}

\item{show}{Print the contents of the Docker file in the R console.}

\item{verbose}{Print messages.}
}
\value{
Path to Issue Templates.
}
\description{
Creates one or more Issue Templates to be used in a GitHub repository.
}
\examples{
path <- use_issue_template(save_dir=tempdir())
}
