% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dml_xlsx.R
\name{dml_xlsx}
\alias{dml_xlsx}
\title{DrawingML graphic device for Microsoft Excel}
\usage{
dml_xlsx(
  file = "Rplots.dml",
  width = 6,
  height = 6,
  offx = 1,
  offy = 1,
  bg = "white",
  fonts = list(),
  pointsize = 12,
  editable = TRUE,
  id = 1L,
  last_rel_id = 1L,
  standalone = TRUE
)
}
\arguments{
\item{file}{the file where output will appear.}

\item{height, width}{Height and width in inches.}

\item{offx, offy}{top and left origin of the plot}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families \code{sans}, \code{serif}, \code{mono} and \code{symbol} are aliased
to the families detected by \code{\link[gdtools:font_set_auto]{gdtools::font_set_auto()}}.

\strong{Important:} fonts are referenced by name in the DrawingML output
and are \strong{not embedded}. The reader of the Excel file must also
have the same fonts installed, otherwise Office will substitute them.
For maximum portability, prefer fonts bundled with Microsoft Office
such as \code{"Arial"}, \code{"Times New Roman"} and \code{"Courier New"}.

Fonts must be installed on your system; use
\code{gdtools::font_family_exists()} to verify availability.

Example: \code{list(sans = "Arial", serif = "Times New Roman", mono = "Courier New")}.}

\item{pointsize}{default point size.}

\item{editable}{should vector graphics elements (points, text, etc.) be editable.}

\item{id}{specifies a unique identifier (integer) within the
sheet that will contain the DrawingML instructions.}

\item{last_rel_id}{specifies the last unique identifier (integer)
within relationship file that will be used to reference embedded
raster images if any.}

\item{standalone}{produce a standalone drawingml file? If \code{FALSE}, omits
xml header and namespaces.}
}
\description{
Graphics devices for Microsoft Excel DrawingML format.
}
\examples{
\donttest{
dml_xlsx(file = tempfile())
plot(1:11, (-5:5)^2, type = "b", main = "Simple Example")
dev.off()
}
}
\seealso{
\code{\link{Devices}}
}
\keyword{device}
