% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dmultinom_rvec}
\alias{dmultinom_rvec}
\alias{rmultinom_rvec}
\title{Multinomial Distribution, Using Multiple Draws}
\usage{
dmultinom_rvec(x, size = NULL, prob, log = FALSE)

rmultinom_rvec(n, size, prob, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{size}{Total number of trials.
See \code{\link[stats:Multinom]{stats::dmultinom()}}.
Can be an rvec.}

\item{prob}{Numeric non-negative vector,
giving the probability of each outcome.
Internally normalized to sum to 1.
See \code{\link[stats:Multinom]{stats::dmultinom()}}.
Can be an rvec.}

\item{log}{Whether to return
\code{log(p)} rather than \code{p}. Default is
\code{FALSE}. Cannot be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item \code{dmultinom()}
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}; otherwise an ordinary R vector.
}
\item \code{rmultinom()}
\itemize{
\item If \code{n} is 1, an rvec or
ordinary R vector; otherwise a list
of rvecs or ordinary R vectors
}
\item Unlike base \code{rmultinom()}, \code{rmultinom_rvec()}
always returns doubles.
}
}
\description{
Density function random generation for the
multinomial distribution, modified to work with
rvecs.
}
\details{
Functions \code{dmultinom_rvec()}and
\code{rmultinom_rvec()} work like
base R functions \code{\link[=dmultinom]{dmultinom()}}
and \code{\link[=rmultinom]{rmultinom()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rmultinom_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

Like the base R functions \code{\link[=dmultinom]{dmultinom()}}
and [rmultinom(), \code{dmultinom_rvec()} and
\code{rmultinom_rvec()} do not recycle their arguments.
}
\examples{
x <- rvec(list(c(1, 4, 0),
               c(1, 0, 0),
               c(1, 0, 0),
               c(1, 0, 4)))
prob <- c(1/4, 1/4, 1/4, 1/4)
dmultinom_rvec(x = x, prob = prob)
rmultinom_rvec(n = 1,
               size = 100,
               prob = c(0.1, 0.4, 0.2, 0.3),
               n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dmultinom]{dmultinom()}}, \code{\link[=rmultinom]{rmultinom()}} Base R equivalents
\item \link[stats:Distributions]{distributions} All base R distributions
}
}
