% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{analyze}
\alias{analyze}
\title{Generate rows analyzing variables across columns}
\usage{
analyze(
  lyt,
  vars,
  afun = simple_analysis,
  var_labels = vars,
  table_names = vars,
  parent_name = NULL,
  format = NULL,
  formats_var = NULL,
  na_str = NA_character_,
  na_strs_var = NULL,
  nested = TRUE,
  inclNAs = FALSE,
  extra_args = list(),
  show_labels = c("default", "visible", "hidden"),
  indent_mod = 0L,
  section_div = NA_character_
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{vars}{(\code{character})\cr vector of variable names.}

\item{afun}{(\code{function})\cr analysis function. Must accept \code{x} or \code{df} as its first parameter. Can optionally take
other parameters which will be populated by the tabulation framework. See Details in \code{\link[=analyze]{analyze()}}.}

\item{var_labels}{(\code{character})\cr vector of labels for one or more variables.}

\item{table_names}{(\code{character})\cr names for the tables representing each atomic analysis. Defaults to \code{var}.}

\item{parent_name}{(\code{character(1)})\cr Name to assign to the table corresponding
to the \emph{split} or \emph{group of sibling analyses}, for \verb{split_rows_by*} and
\verb{analyze*} when analyzing more than one variable, respectively. Ignored when
analyzing a single variable.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{formats_var}{(\code{string} or \code{NULL})\cr \code{NULL} (the default) or the name of the list column containing named
lists of default formats to use. These will be applied with the same precedence as the \code{format} argument; i.e.,
they will not override formats (other than \code{"default"}) set within the afun.
Cannot be used simultaneously with \code{format}.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{na_strs_var}{(\code{string} or \code{NULL})\cr \code{NULL} (the default) or the name of the list column containing named
lists of default NA strings to use. These will be applied with the same precedence as the \code{format} argument; i.e.,
they will not override formats (other than \code{"default"}) set within the afun.
Cannot be used simultaneously with \code{format}. Cannot be used if \code{formats_var} is \code{NULL}.}

\item{nested}{(\code{logical})\cr whether this layout instruction should be applied within the existing layout structure
\emph{if possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{inclNAs}{(\code{logical})\cr whether NA observations in the \code{var} variable(s) should be included when performing
the analysis. Defaults to \code{FALSE}.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{show_labels}{(\code{string})\cr whether the variable labels corresponding to the variable(s) in \code{vars}
should be visible in the resulting table.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after the set of rows  defined
by (each sub-analysis/variable) of this analyze instruction, or
\code{NA_character_} (the default) for no section divider. This section
divider will be overridden by a split-level section divider when
both apply to the same position in the rendered output.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
Adding \emph{analyzed variables} to our table layout defines the primary tabulation to be performed. We do this by
adding calls to \code{analyze} and/or \code{\link[=analyze_colvars]{analyze_colvars()}} into our layout pipeline. As with adding further splitting,
the tabulation will occur at the current/next level of nesting by default.
}
\details{
When \code{length(vars) > 1} and when two calls to \code{analyze}
are done in sequence (the second with the default \code{nested = TRUE}), the analyses will be combined into a multi-variable
analysis that will be reflected in the row structure of the
resulting table. In these cases, the default is to show the
label describing the variable analyzed for each of the
resulting subtables, while that is hidden by default in
one-variable cases.
}
\note{
None of the arguments described in \link{additional_fun_params} can be overridden via \code{extra_args} or when calling
\code{\link[=make_afun]{make_afun()}}. \code{.N_col} and \code{.N_total} can be overridden via the \code{col_counts} argument to \code{\link[=build_table]{build_table()}}.
Alternative values for the others must be calculated within \code{afun} based on a combination of extra arguments and
the unmodified values provided by the tabulation framework.
}
\section{Specifying Default Formatting Behavior}{
\emph{Default} formatting behavior for rows generated by \code{afun} can be
specified by one of \code{format} or \code{formats_var}. In both cases, these
default formatting instructions \emph{will not} supersede formatting
specified from within \code{afun} at either the \code{rcell} or \code{in_rows}
call levels; They will only apply to rows/cells whose formatting as
returned by \code{afun} is either \code{NULL} or \code{"default"}.  When
non-\code{NULL}, \code{format} is used to specify formats for all generated
rows, and can be a character vector, a function, or a list of
functions. It will be repped out to the number of rows once this is
calculated during the tabulation process, but will be overridden by
formats specified within \code{rcell} calls in \code{afun}.

\code{format} can accept a format label string (see
\code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}}), a formatting function, an
unnamed list, or a named list.

When \code{format} is an unnamed list - or a named list where not all
values of \code{vars} appear in the names - its elements will be repped
out to the number of rows generated by \code{afun} (separately) within
each row facet \code{afun} is applied within. \strong{This includes recycling
behavior, even in the case where the number of rows is not cleanly
divisible by the number of specified formats}. This behavior is
retained largely for legacy reasons and switching to the new
named-list behavior is advised where applicable.

When \code{format} is a named list whose names contain all values in
\code{vars}, the elements of \code{format} are taken to be specific to the
analysis of the corresponding variable; this allows us to specify a
multi-variable analysis where e.g., the different variables are
analyzed by the same \code{afun} but have different levels of
measurement precision (and thus different formatting needs). In
this case the var-specific formatting can be a single format (label
string or function) or can be a named list whose names will be
matched up to those of the rows generated by applying \code{afun} in
each row facet. Matching of formats to rows is performed the same
as in the \code{formats_var} case and is described below.

When \code{formats_var} is non-\code{NULL}, it specifies the name of a list
column containing formatting instructions for one or more rows
\code{afun} will generate when applied within a row facet. This can be
used when the analysis results for a single variable (e.g., \code{value}
or \code{AVAL} in long-form data) should be formatted differently within
different row facets (e.g., when faceting on \code{statistic} or
\code{PARAMCD}). The value of \code{df[[formats_var]]} is assumed without
verification to be constant within each row facet \code{afun} is applied
within, and the first (list) value of the column within the row
facet data will be used.

In the \code{formats_var} case as well as the case of \code{format} being a
named list containing the values of \code{vars}, after rows are created
during tabulation, the default formats are matched and applied to
them as follows:
\enumerate{
\item When the generated row's name (as given by \code{obj_name}) matches
a name in the list, the corresponding default format is applied,
\item for those without exact matches, the default format whose name
provides \emph{the best partial match} to each row name is applied,
\item For those without default format names that partially match
the row name, no default format is applied.
}

Note carefully that in (2), it is the names of the list of formats
that are partially matching the row names not the other way around.
}

\section{The Analysis Function}{
The analysis function (\code{afun}) should take as its first parameter either \code{x} or \code{df}. Whichever of these the
function accepts will change the behavior when tabulation is performed as follows:
\itemize{
\item If \code{afun}'s first parameter is \code{x}, it will receive the corresponding subset \emph{vector} of data from the relevant
column (from \code{var} here) of the raw data being used to build the table.
\item If \code{afun}'s first parameter is \code{df}, it will receive the corresponding subset \emph{data frame} (i.e. all columns) of
the raw data being tabulated.
}

In addition to differentiation on the first argument, the analysis function can optionally accept a number of
other parameters which, \emph{if and only if} present in the formals, will be passed to the function by the tabulation
machinery. These are listed and described in \link{additional_fun_params}.
}

\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", afun = list_wrap_x(summary), format = "xx.xx")
lyt

tbl <- build_table(lyt, DM)
tbl

lyt2 <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  analyze(head(names(iris), -1), afun = function(x) {
    list(
      "mean / sd" = rcell(c(mean(x), sd(x)), format = "xx.xx (xx.xx)"),
      "range" = rcell(diff(range(x)), format = "xx.xx")
    )
  })
lyt2

tbl2 <- build_table(lyt2, iris)
tbl2

}
\author{
Gabriel Becker
}
