% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyserial.R
\name{polyserial_initialize_param}
\alias{polyserial_initialize_param}
\title{Neutral initialization of starting values for polyserial correlation}
\usage{
polyserial_initialize_param(x, num_y, robust = FALSE)
}
\arguments{
\item{x}{Vector of numeric values}

\item{num_y}{Number of response options of ordinal variable}

\item{robust}{Should values of \code{mu} and \code{sigma2} be initialized in robust way (that is, median and squared MAD)? If \code{FALSE} (default), then nonrobust sample mean and variance are used.}
}
\value{
A vector of initial values for the polyserial correlation coefficient, mu, sigma2, and Y-threshold parameters
}
\description{
Initializes starting values for numerical optimization in a neutral way.
}
\examples{
## example data
set.seed(123)
x <- rnorm(100)
polyserial_initialize_param(x = x, num_y = 3)

}
