/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.processing;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarDefinition;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.TsDataSuppliers;
import jdplus.toolkit.base.xml.legacy.calendars.CalendarAdapters;
import jdplus.toolkit.base.xml.legacy.calendars.XmlCalendar;
import jdplus.toolkit.base.xml.legacy.calendars.XmlCalendars;
import jdplus.toolkit.base.xml.legacy.processing.XmlTsVariables;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ProcessingContext")
@XmlType(name="ProcessingContextType", propOrder={"variables", "calendars"})
public class XmlProcessingContext {
    @XmlElement(name="Variables", required=true)
    protected Variables variables;
    @XmlElement(name="Calendars", required=true)
    protected XmlCalendars calendars;

    public Variables getVariables() {
        return this.variables;
    }

    public void setVariables(Variables value) {
        this.variables = value;
    }

    public XmlCalendars getCalendars() {
        return this.calendars;
    }

    public void setCalendars(XmlCalendars value) {
        this.calendars = value;
    }

    public static XmlProcessingContext marshal(ModellingContext v) {
        int count;
        XmlProcessingContext xml = new XmlProcessingContext();
        if (!v.getCalendars().isEmpty()) {
            xml.calendars = new XmlCalendars();
            String[] names = v.getCalendars().getNames();
            for (int i = 0; i < names.length; ++i) {
                CalendarDefinition cur = (CalendarDefinition)v.getCalendars().get(names[i]);
                XmlCalendar xcur = CalendarAdapters.getDefault().marshal(cur);
                if (xcur == null) continue;
                xcur.setName(names[i]);
                xml.calendars.getCalendars().add(xcur);
            }
        }
        if ((count = v.getTsVariableManagers().getCount()) > 0) {
            xml.variables = new Variables();
            for (String n : v.getTsVariableManagers().getNames()) {
                TsDataSuppliers cur = v.getTsVariables(n);
                if (cur.isEmpty()) continue;
                XmlTsVariables xcur = XmlTsVariables.marshal(cur);
                xcur.setName(n);
                xml.variables.getGroup().add(xcur);
            }
        }
        return xml;
    }

    public static boolean unmarshal(XmlProcessingContext xml, ModellingContext v) {
        if (xml.calendars != null) {
            for (XmlCalendar xcal : xml.calendars.getCalendars()) {
                CalendarDefinition cal = CalendarAdapters.getDefault().unmarshal(xcal);
                v.getCalendars().set(xcal.getName(), (Object)cal);
            }
        }
        if (xml.variables != null) {
            for (XmlTsVariables xcur : xml.variables.getGroup()) {
                TsDataSuppliers vars = XmlTsVariables.unmarshal(xcur);
                v.getTsVariableManagers().set(xcur.getName(), (Object)vars);
            }
        }
        return true;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"group"})
    public static class Variables {
        @XmlElement(name="Group")
        private List<XmlTsVariables> group = new ArrayList<XmlTsVariables>();

        public List<XmlTsVariables> getGroup() {
            return this.group;
        }
    }
}

