% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains_vignette_folder.R
\name{contains_vignette_folder}
\alias{contains_vignette_folder}
\title{Check for Vignette Folder and .Rmd Files in a .tar File}
\usage{
contains_vignette_folder(tar_file)
}
\arguments{
\item{tar_file}{A character string specifying the path to the .tar file to be checked.}
}
\value{
A logical value: \code{TRUE} if the 'vignettes' folder exists and contains at least one .Rmd file,
and neither 'vignettes' nor 'inst/doc' folders are present, \code{FALSE} otherwise.
}
\description{
This function checks if a given .tar file contains a 'vignettes' folder
and if there is at least one .Rmd file within that folder. If both 'vignettes'
and 'inst/doc' folders exist, the function will return \code{FALSE}.
}
\details{
The function checks if the specified file exists and has a valid .tar extension using \code{utils::untar}. If the file is empty or
any error occurs during the extraction, the function stops and returns an error message. If both 'vignettes'
and 'inst/doc' folders exist, the function returns \code{FALSE}. If the 'vignettes' folder exists and contains 
at least one .Rmd file, the function returns \code{TRUE}. Otherwise, it returns \code{FALSE}.
}
\examples{
\dontrun{
  tar_file <- system.file("test-data", "here-1.0.1.tar.gz", 
   package = "risk.assessr")
  result <- contains_vignette_folder(tar_file)
  print(result)
}

}
