% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_host_info.R
\name{check_and_fetch_cran_package}
\alias{check_and_fetch_cran_package}
\title{Check and Fetch CRAN Package}
\usage{
check_and_fetch_cran_package(package_name, package_version = NULL)
}
\arguments{
\item{package_name}{A character string specifying the name of the package to check and fetch.}

\item{package_version}{An optional character string specifying the version of the package to fetch. Defaults to `NULL`.}
}
\value{
A list with one of the following structures:

\describe{
  \item{package_url}{Character string; the URL to download the package tarball.}
  \item{last_version}{A named list with \code{version} and \code{date} for the latest available version.}
  \item{version}{Character string; the requested version (or \code{NULL} if not specified).}
  \item{all_versions}{A list of named lists, each with \code{version} and \code{date}, representing all available versions.}
}
}
\description{
This function checks if a package exists on CRAN and retrieves the corresponding package URL and version details.
If a specific version is not provided, the latest version is used.
}
\examples{
\dontrun{
# Check and fetch a specific version of "ggplot2"
result <- check_and_fetch_cran_package("ggplot2", package_version = "3.3.5")
print(result)
}

}
