% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cossim.R
\name{cosdist}
\alias{cosdist}
\title{Calculate the cosine distance between two vectors (matrices)}
\usage{
cosdist(x, y, na.rm = TRUE)
}
\arguments{
\item{x}{An integer or numeric vector or matrix}

\item{y}{An integer or numeric vector or matrix}

\item{na.rm}{Logical, whether \code{NA} should be removed}
}
\value{
Numeric vector or matrix, the cossine similarity between the inputs
}
\description{
Calculate the cosine distance between two vectors (matrices)
}
\details{
Cossine distance is defined by \eqn{1-cossim}, where \eqn{cossim} represents the cosine similarity.

If parameters are given as matrices, the function calculates the cossine distance between all pair of \emph{columns} of both matrices.
}
\note{
Currently, \code{na.rm} is only considered when both inputs are vectors
}
\examples{
testVal1 <- rnorm(10)
testVal2 <- rnorm(10)
testVal3 <- c(rnorm(9), NA)

cosdist(testVal1, testVal2)
cosdist(testVal1, testVal3, na.rm=TRUE)
cosdist(testVal1, testVal3, na.rm=FALSE)
## test matrix
testMat1 <- matrix(rnorm(1000), nrow=10)
testMat2 <- matrix(rnorm(1000), nrow=10)

testVecMatDist1 <- cosdist(testMat1[,1L], testMat2)
testVecMatDist <- cosdist(testMat1, testMat2)
}
\references{
\url{https://en.wikipedia.org/wiki/Cosine_similarity}
}
\seealso{
\code{\link{cor}}, \code{\link{cossim}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
