% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite_graph.R
\name{plotlyBipartiteGraph}
\alias{plotlyBipartiteGraph}
\title{Plot a bipartite graph using plot_ly}
\usage{
plotlyBipartiteGraph(
  g,
  layout = layout_as_bipartiteLR(g),
  edge.line = list(color = "#030303", width = 0.3),
  axis = list(title = "", showgrid = FALSE, showticklabels = FALSE, zeroline = FALSE),
  title = ""
)
}
\arguments{
\item{g}{A \code{igraph} object of a bipartite graph}

\item{layout}{The layout, the LR layout is used by default}

\item{edge.line}{List, specifying edge lines}

\item{axis}{List, specifying axes}

\item{title}{Character string, plot title}
}
\value{
A \code{plotly} and \code{htmlwidget} object

If the layout is left-right, the function takes care of the alignment of labels
}
\description{
Plot a bipartite graph using plot_ly
}
\examples{
myDataFrame <- data.frame(word=c("ja", "nein", "yes", "no", "stark", "stark"),
  language=c("German", "German", "English", "English", "English", "German"))
myBpGraph <- bipartite_graph_from_data_frame(myDataFrame)
plotlyBipartiteGraph(myBpGraph)
}
