/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.common;

import usf.saav.common.Timer;

public class TimerAverage
implements Timer {
    private Timer baseTimer;
    private double msTotal = 0.0;
    private double nsTotal = 0.0;
    private int count = 0;

    public TimerAverage(Timer timer) {
        this.baseTimer = timer;
    }

    @Override
    public void start() {
        this.baseTimer.start();
    }

    @Override
    public void end() {
        this.baseTimer.end();
        this.msTotal += this.baseTimer.getElapsedMilliseconds();
        this.nsTotal += this.baseTimer.getElapsedNanoseconds();
        ++this.count;
    }

    @Override
    public double getElapsedMilliseconds() {
        return this.msTotal / (double)this.count;
    }

    @Override
    public double getElapsedNanoseconds() {
        return this.nsTotal / (double)this.count;
    }
}

