% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trophic_ecology.R
\name{ecology}
\alias{ecology}
\title{ecology}
\usage{
ecology(
  species_list = NULL,
  fields = NULL,
  server = c("fishbase", "sealifebase"),
  version = "latest",
  db = NULL,
  ...
)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{fields}{subset to these columns.  (recommend to omit this and handle manually)}

\item{server}{Either "fishbase" or "sealifebase".}

\item{version}{a version string for the database. See \code{\link[=available_releases]{available_releases()}} for details.}

\item{db}{database connection, now deprecated.}

\item{...}{additional arguments, currently ignored}
}
\value{
a table of species ecology data
}
\description{
ecology
}
\details{
By default, will only return one entry (row) per species.  Increase limit to
get multiple returns for different stocks of the same species, though often data is either
identical to the first or simply missing in the additional stocks.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\dontrun{
ecology("Oreochromis niloticus")

## trophic levels and standard errors for a list of species
ecology(c("Oreochromis niloticus", "Salmo trutta"),
        fields=c("SpecCode", "FoodTroph", "FoodSeTroph", "DietTroph", "DietSeTroph"))
}
\dontshow{\}) # examplesIf}
}
\references{
http://www.fishbase.org/manual/english/fishbasethe_ecology_table.htm
}
