% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.r
\name{add_content}
\alias{add_content}
\title{Add content to a report}
\usage{
add_content(
  x,
  object,
  page_break = TRUE,
  align = "center",
  blank_row = "below"
)
}
\arguments{
\item{x}{The report_spec to append content to.}

\item{object}{The object to append.}

\item{page_break}{Whether to add a page break after the object. 
Valid values are TRUE or FALSE.  You can manipulate the \code{page_break} 
parameter to add multiple objects to the same page.}

\item{align}{How to align the content.  Valid values are 'left', 'right',
'center', and 'centre'.}

\item{blank_row}{Whether to put a blank row above or below the content.
Valid values are 'above', 'below', 'both', or 'none'.}
}
\value{
The modified report_spec.
}
\description{
This function adds an object to the report content list. A 
report will accept multiple pieces of content.  The \code{add_content} 
function also controls overall alignment of the content on the page, and
whether there is a page break before or after.
}
\details{
The \code{add_content} function adds a piece of content to a report. For a 
text report, valid objects are a table or text object.  For an RTF, PDF,  
HTML, or DOCX report, valid objects are a table, text, or plot object.  See 
\code{\link{create_table}}, \code{\link{create_text}}, or 
\code{\link{create_plot}} for further 
information on how to create content objects.  

Content will be
appended to the report in the order it is added.  By default, a page break
is added after the content.  You can stack two pieces of content together
closely by setting the \code{page_break} parameter to FALSE, and 
the \code{blank_row} parameter to "none".
}
\examples{
library(reporter)
library(magrittr)

# Create temp file path
tmp <- file.path(tempdir(), "mtcars.txt")

# Create first table 
tbl1 <- create_table(mtcars[1:5, 1:6]) \%>\% 
  column_defaults(width = .5) 

# Create second table
tbl2 <- create_table(mtcars[6:10, 1:6], headerless=TRUE) \%>\% 
  column_defaults(width = .5) 

# Create the report object
rpt <- create_report(tmp) \%>\%
  titles("MTCARS Sample Data", align = "left") \%>\%
  add_content(tbl1, page_break = FALSE, align = "left", blank_row = "none") \%>\%
  add_content(tbl2, page_break = FALSE, align = "left") \%>\%
  add_content(create_text("* NOTE: Above table is actually two tables stacked."))

# Write the report to the file system
res <- write_report(rpt)

# Write report to console
writeLines(readLines(tmp, encoding = "UTF-8"))

# MTCARS Sample Data
# 
#    mpg    cyl   disp     hp   drat     wt
# -----------------------------------------
#     21      6    160    110    3.9   2.62
#     21      6    160    110    3.9  2.875
#   22.8      4    108     93   3.85   2.32
#   21.4      6    258    110   3.08  3.215
#   18.7      8    360    175   3.15   3.44
#   18.1      6    225    105   2.76   3.46
#   14.3      8    360    245   3.21   3.57  
#   24.4      4  146.7     62   3.69   3.19
#   22.8      4  140.8     95   3.92   3.15
#   19.2      6  167.6    123   3.92   3.44
# 
# * NOTE: Above table is actually two tables stacked.
}
\seealso{
\code{\link{create_table}}, \code{\link{create_text}}, and
\code{\link{create_plot}} to create content for a report.

Other report: 
\code{\link{create_report}()},
\code{\link{footer_image}()},
\code{\link{footnotes}()},
\code{\link{header_image}()},
\code{\link{options_fixed}()},
\code{\link{page_by}()},
\code{\link{page_footer}()},
\code{\link{page_header}()},
\code{\link{print.report_spec}()},
\code{\link{set_margins}()},
\code{\link{title_header}()},
\code{\link{titles}()},
\code{\link{write_report}()}
}
\concept{report}
