% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_expvarlist.R
\name{ru_expvarlist}
\alias{ru_expvarlist}
\title{Expand SAS Style Variable/Column List}
\usage{
ru_expvarlist(dsetin, varsin = NULL, keepnotexist = FALSE)
}
\arguments{
\item{dsetin}{A dataframe holding columns whose names will be expanded.}

\item{varsin}{A SAS style list of variable names.}

\item{keepnotexist}{If the variable does not exist on the dataframe it will be excluded from the list.}
}
\value{
A list of column/variable names.
}
\description{
Pass in a data frame along with column/variable identifiers formatted with SAS Style (i.e., using colon) and it will be expanded to the actual variable list.
}
\examples{
library(repfun)
df <- data.frame(tt_ac01=c('1','2','3'),
                 tt_ac02=c('a','b','b'),
                 tt_ac03=c('10','11','12'))
chk <- repfun::ru_expvarlist(df, varsin="tt_ac:")
print(chk)

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
