% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{growth_incomplete}
\alias{growth_incomplete}
\title{Berkeley Growth Study data with simulated incompleteness}
\format{
A dataframe made up of \describe{
 \item{id}{A unique subject identifier;}
 \item{index}{Observed age of the child's height;}
 \item{value}{First derivative of the height development in the given age.}
}
}
\usage{
data(growth_incomplete)
}
\description{
This dataset from the Berkeley Growth Study comprises the height
development of 39 boys and 54 girls between ages 1 and 18.
It is based on the dataset \code{fda::growth} and focuses not on the observed
heights, but on the first derivatives of the curves. Before taking the
first derivative, the curves were slightly smoothed. \cr \cr
To showcase the functionality of the \code{registr} package regarding the
analysis of incomplete curves, the growth curves were artificially made
incomplete. For each child, leading incompleteness was simulated by drawing
a random initial age in the first quarter of the domain.
Also, trailing incompleteness was simulated by drawing
a random cut-off age in the second half of the domain.
}
\references{
Ramsay, J. O., and Silverman, B. W. (2006),
\emph{Functional Data Analysis, 2nd ed.}, Springer, New York.

Tuddenham, R. D., and Snyder, M. M. (1954).
Physical growth of California boys and girls from birth to age 18.
\emph{University of California Publications in Child Development}, 1, 183-364.
}
\keyword{datasets}
